/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.config.server.ExplosionConfigVVP;
import tech.vvp.vvp.init.ModEntities;

public class Fab500Entity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(Fab500Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier().immuneTo((EntityType)ModEntities.FAB_500.get());
    private float explosionDamage = ((Integer)ExplosionConfigVVP.FAB_500_EXPLOSION_DAMAGE.get()).intValue();
    private float explosionRadius = ((Double)ExplosionConfigVVP.FAB_500_EXPLOSION_RADIUS.get()).floatValue();
    private float gravity = 0.06f;
    public int durability = 1;

    public Fab500Entity(EntityType<? extends Fab500Entity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public Fab500Entity(LivingEntity entity, Level level) {
        super((EntityType)ModEntities.FAB_500.get(), (Entity)entity, level);
        this.f_19811_ = true;
    }

    public Fab500Entity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends Fab500Entity>)((EntityType)ModEntities.FAB_500.get()), level);
    }

    public Fab500Entity(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
        this.f_19811_ = true;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @NotNull
    protected Item m_7881_() {
        return (Item)ModItems.MEDIUM_AERIAL_BOMB.get();
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        float newAmount = DAMAGE_MODIFIER.compute(source, amount);
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - newAmount));
        return super.m_6469_(source, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(50.0f));
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        }
        if (compound.m_128441_("ExplosionDamage")) {
            this.explosionDamage = compound.m_128457_("ExplosionDamage");
        }
        if (compound.m_128441_("Radius")) {
            this.explosionRadius = compound.m_128457_("Radius");
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        compound.m_128350_("ExplosionDamage", this.explosionDamage);
        compound.m_128350_("Radius", this.explosionRadius);
    }

    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, (float)this.explosionDamage, (float)this.explosionRadius, (float)1.2f);
        }
        this.m_146870_();
    }

    public boolean m_6783_(double pDistance) {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 600 || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            if (!this.m_9236_().f_46443_) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, (float)this.explosionDamage, (float)this.explosionRadius, (float)1.2f);
            }
            this.m_146870_();
        }
    }

    private PlayState movementPredicate(AnimationState<Fab500Entity> event) {
        return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.mk_82.start"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public SoundEvent getCloseSound() {
        return SoundEvents.f_271165_;
    }

    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    public float getVolume() {
        return 0.7f;
    }

    public boolean shouldSyncMotion() {
        return true;
    }

    public void setDamage(float damage) {
    }

    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float m_7139_() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }
}

